# **Antivirus and Antispyware Software**

- **Declining Efficacy, but Still Valuable for Telemetry:** Host-based antivirus and antispyware programs are losing reputation due to their low level of efficacy, but they are still valuable sources of telemetry.

## **1. Antivirus Software**

- **Original Purpose:** Detecting and removing computer viruses.
- **Expanded Scope:** Now targets various types of malware:
    - Keystroke loggers
    - Back doors
    - Rootkits
    - Browser hijackers
    - Trojan horses
    - Ransomware
- **Efficacy:** Varies by vendor and specific threat; overall efficacy is decreasing while malware proliferation increases.
- **Computer Virus Definition:** A type of malware that propagates by inserting a copy of itself into another program, spreading from computer to computer and causing effects ranging from annoyance to data damage and DoS.
- **Detection Methods:**
    - **Signature-Based Detection:**
        - Vendors analyze known malware and create signatures.
        - Software scans for these signatures in files and memory.
        - **Shortcoming:** Ineffective against zero-day attacks.
    - **Heuristics:**
        - Recognizes imprecise signature matches.
        - Helps detect malware variants and families.
    - **Behavioral-Based Detection:**
        - Monitors process behavior for malicious actions (e.g., modifying executables, capturing keystrokes).
        - Provides some protection against zero-day threats.
- **Database Maintenance:** Regular updates are crucial for effective protection.
- **Real-Time Protection:** Analyzes data as it's loaded into memory, providing immediate defense.

## **2. Antispyware Software**

- **Purpose:** Detect and remove spyware.
- **Spyware Definition:** Software that gathers information without raising awareness.
- **Blurring Lines:**
    - The distinction between malware and spyware is not always clear.
    - Keystroke loggers are considered spyware but often cross the line into malware.
- **Adware:**
    - Users agree to see ads in exchange for software use.
    - Becomes spyware if the user is unaware of targeted ads or if tracking data is used for malicious purposes (e.g., phishing).
- **Tracking Cookies:** A common form of spyware in internet browsers.
- **Overlap with Antivirus:** There is often overlapping protection between antivirus and antispyware software.